/*:
 * @target MZ
 * @author Aerosys
 * @plugindesc [Tier 1] [Version 1.0.3] [MV & MZ]
 * 
 * @help
 * 
 * ----------------------------------------------------------------------------
 * Rules
 * ----------------------------------------------------------------------------
 * 
 * 1. This Plugin is free of charge and can be used in any kind of game.
 * 
 * 2. You may not redistribute this Plugin or claim it as your own.
 *    
 *    a) Exception: You may redistribute this plugin as part of your game when
 *       releasing it.
 *    b) Exception: You may send this plugin to another person when you hire
 *       them for personal modifications.
 * 
 * 3. You may modify this plugin's source code for your needs but cannot
 *    redistribute your modifications.
 * 
 * 4. You may create plugins based on this (e.g. addon or extension) for your
 *    needs but you cannot redistribute them.
 * 
 * 
 * NEED SUPPORT?
 * Contact me: mail<at>aerosys.blog
 * 
 * @endofhelp
 * 
 * 
 * @param defaultValues
 * @text Default Values
 *
 * @param alwaysDash
 * @parent defaultValues
 * @text Always Dash
 * @type boolean
 * @default true
 * 
 * @param commandRemember
 * @parent defaultValues
 * @text Command Remember
 * @type boolean
 * @default false
 * 
 * @param touchUI
 * @parent defaultValues
 * @text Touch UI (MZ only)
 * @type select
 * @option on
 * @option when on mobile
 * @option off
 * @default when on mobile
 * @desc Only enabled when on MZ
 * 
 * @param bgmVolume
 * @parent defaultValues
 * @text BGM
 * @type number
 * @default 10
 * 
 * @param bgsVolume
 * @parent defaultValues
 * @text BGS
 * @type number
 * @default 10
 * 
 * @param meVolume
 * @parent defaultValues
 * @text ME
 * @type number
 * @default 10
 * 
 * @param seVolume
 * @parent defaultValues
 * @text SE
 * @type number
 * @default 10
 * 
 * @param volumeOffset
 * @parent defaultValues
 * @text Offset
 * @type number
 * @default 10
 * @desc Offset in the Options Menu
 * 
 * @param a
 * @text _
 * 
 * @param includeInMenu
 * @text Show in Menu?
 * 
 * @param includeAlwaysDash
 * @parent includeInMenu
 * @text Always Dash
 * @type boolean
 * @default true
 * 
 * @param includeCommandRemember
 * @parent includeInMenu
 * @text Command Remember
 * @type boolean
 * @default true
 * 
 * @param includeTouchUI
 * @parent includeInMenu
 * @text Touch UI (MZ only)
 * @type select
 * @option on
 * @option when on mobile
 * @option off
 * @default when on mobile
 * @desc Only enabled when on MZ
 * 
 * @param includeBgmVolume
 * @parent includeInMenu
 * @text BGM
 * @type boolean
 * @default true
 * 
 * @param includeBgsVolume
 * @parent includeInMenu
 * @text BGS
 * @type boolean
 * @default true
 * 
 * @param includeMeVolume
 * @parent includeInMenu
 * @text ME
 * @type boolean
 * @default true
 * 
 * @param includeSeVolume
 * @parent includeInMenu
 * @text SE
 * @type boolean
 * @default true
 * 
 */

var MK = MK || { };


(function() {


const PLUGIN_NAME = 'MK_DefaultOptionValues';

const reject = (reason) => {
    const message = (
        "An Error has occurred in the Plugin %1: %2 " +
        "If the problem persists, contact the Plugin Creator."
    ).format(PLUGIN_NAME, reason);
    throw Error(message);
}

if (!PluginManager._parameters[PLUGIN_NAME.toLowerCase()]) {
    reject((
        "Please check that this plugin's filename is \"%1.js\". " +
        "Subdirectories (e.g.: js/plugins/xy/thisPlugin.js) are not allowed."
    ).format(PLUGIN_NAME));
}

const params = PluginManager.parameters(PLUGIN_NAME);
MK.DefaultOptionValues = { };

MK.DefaultOptionValues.alwaysDash               = 'true' == params.alwaysDash;
MK.DefaultOptionValues.commandRemember          = 'true' == params.commandRemember;
MK.DefaultOptionValues.bgmVolume                = Number(params.bgmVolume || 0);
MK.DefaultOptionValues.bgsVolume                = Number(params.bgsVolume || 0);
MK.DefaultOptionValues.meVolume                 = Number(params.meVolume || 0);
MK.DefaultOptionValues.seVolume                 = Number(params.seVolume || 0);
MK.DefaultOptionValues.volumeOffset             = Number(params.volumeOffset || 1);
MK.DefaultOptionValues.includeAlwaysDash        = 'true' == params.includeAlwaysDash;
MK.DefaultOptionValues.includeCommandRemember   = 'true' == params.includeCommandRemember;
MK.DefaultOptionValues.includeBgmVolume         = 'true' == params.includeBgmVolume;
MK.DefaultOptionValues.includeBgsVolume         = 'true' == params.includeBgsVolume;
MK.DefaultOptionValues.includeMeVolume          = 'true' == params.includeMeVolume;
MK.DefaultOptionValues.includeSeVolume          = 'true' == params.includeSeVolume;

MK.DefaultOptionValues.touchUI = (
    'MZ' == Utils.RPGMAKER_NAME && (
        'on' == params.touchUI ||
        ('when on mobile' == params.touchUI && Utils.isMobileDevice())
    )
);

MK.DefaultOptionValues.includeTouchUI = (
    'MZ' == Utils.RPGMAKER_NAME && (
        'on' == params.includeTouchUI ||
        ('when on mobile' == params.includeTouchUI && Utils.isMobileDevice())
    )
);


if ('MZ' == Utils.RPGMAKER_NAME) {
  
    // Override
    AudioManager._bgmVolume = MK.DefaultOptionValues.bgmVolume;
    AudioManager._bgsVolume = MK.DefaultOptionValues.bgsVolume;
    AudioManager._meVolume  = MK.DefaultOptionValues.meVolume;
    AudioManager._seVolume  = MK.DefaultOptionValues.seVolume;

    // Override
    ConfigManager.alwaysDash      = MK.DefaultOptionValues.alwaysDash;
    ConfigManager.commandRemember = MK.DefaultOptionValues.commandRemember;
    ConfigManager.touchUI         = MK.DefaultOptionValues.touchUI;

    const alias_ConfigManager_readVolume = ConfigManager.readVolume;
    ConfigManager.readVolume = function(config, name) {
        if (!(name in config)) {
            if ('bgmVolume' == name)    return MK.DefaultOptionValues.bgmVolume;
            if ('bgsVolume' == name)    return MK.DefaultOptionValues.bgsVolume;
            if ('meVolume' == name)     return MK.DefaultOptionValues.meVolume;
            if ('seVolume' == name)     return MK.DefaultOptionValues.seVolume;
        }
        return alias_ConfigManager_readVolume.apply(this, arguments);
    }
}

if ('MV' == Utils.RPGMAKER_NAME) {
    const alias_ConfigManager_readVolume = ConfigManager.readVolume;
    ConfigManager.readVolume = function(config, name) {
        if (!(name in config)) {
            if ('bgmVolume' == name)    return MK.DefaultOptionValues.bgmVolume;
            if ('bgsVolume' == name)    return MK.DefaultOptionValues.bgsVolume;
            if ('meVolume' == name)     return MK.DefaultOptionValues.meVolume;
            if ('seVolume' == name)     return MK.DefaultOptionValues.seVolume;
        }
        return alias_ConfigManager_readVolume.apply(this, arguments);
    }

    const alias_ConfigManager_readFlag = ConfigManager.readFlag;
    ConfigManager.readFlag = function(config, name) {
        if (!(name in config)) {
            if ('alwaysDash' == name)       return MK.DefaultOptionValues.alwaysDash;
            if ('commandRemember' == name)  return MK.DefaultOptionValues.commandRemember;
            if ('touchUI' == name)          return MK.DefaultOptionValues.touchUI;
        }
        return alias_ConfigManager_readFlag.apply(this, arguments);
    }
}


// Override
Window_Options.prototype.volumeOffset = function() {
    return MK.DefaultOptionValues.volumeOffset;
};

const alias_WindowOptions_addCommand = Window_Options.prototype.addCommand;
Window_Options.prototype.addCommand = function(_, symbol) {
    let b = true;

    if ('alwaysDash' == symbol)         b = MK.DefaultOptionValues.includeAlwaysDash;
    if ('commandRemember' == symbol)    b = MK.DefaultOptionValues.includeCommandRemember;
    if ('touchUI' == symbol)            b = MK.DefaultOptionValues.includeTouchUI;
    if ('bgmVolume' == symbol)          b = MK.DefaultOptionValues.includeBgmVolume;
    if ('bgsVolume' == symbol)          b = MK.DefaultOptionValues.includeBgsVolume;
    if ('meVolume' == symbol)           b = MK.DefaultOptionValues.includeMeVolume;
    if ('seVolume' == symbol)           b = MK.DefaultOptionValues.includeSeVolume;

    if (b) {
        alias_WindowOptions_addCommand.apply(this, arguments);
    }
}


})();
